//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Client::DoReceiveData(void)
{
	if(SizeOfReceiveData > 0)
        return false;

	if( FD_ISSET(Socket, &ReadFDS) )
	{
        char LocalReceiveData[MaxReceiveSize + 1];
		int Result = 0;

		// DoReceiveData- Receiving...

		Result = recv(Socket, LocalReceiveData, MaxReceiveSize,0);

		if(Result == WSAEDISCON)
		{
			DisconnectClient();
			// DoReceiveData- WSAEDISCON
			return false;
		}

		if(Result == WSAECONNRESET)
		{
			DisconnectClient();
			// DoReceiveData- WSAECONNRESET
			return false;
		}

		if(Result == 0)
		{
			DisconnectClient();
			// DoReceiveData- Gracefull disconnect.
			return false;
		}

		if(Result == SOCKET_ERROR)
		{
			DisconnectClient();
			// DoReceiveData- Socket Error
			return false;
		}

		FreeClientReceive();
        RecvOffset = 0;
		ReceiveData = (char *) calloc(MaxReceiveSize,1);
        //Decode(&BaseCommCript, LocalReceiveData, ReceiveData, Result);
        memcpy(ReceiveData, LocalReceiveData, Result);
		SizeOfReceiveData = Result;

		return true;
	}

	return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

